package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@JsonIgnoreProperties(value = {"all"})
public class LectureContainer implements Serializable {
    private List<Lecture> lectures;

    public LectureContainer() {
        lectures = new ArrayList<Lecture>();
    }

    public List<Lecture> getLectures() {
        return lectures;
    }

    public void setLectures(List<Lecture> lectures) {
        this.lectures = lectures;
    }

    private Lecture search(String initials) {
        Lecture lecture;
        Iterator<Lecture> it = this.lectures.iterator();
        while (it.hasNext()) {
            lecture = it.next();
            if (lecture.isEqualTo(initials)) {
                return lecture;
            }
        }
        return null;
    }

    public List<Lecture> getAll() {
        List<Lecture> newlist = new ArrayList();
        newlist.addAll(this.lectures);
        return newlist;
    }

    public Lecture get(String initials) {
        Lecture lecture = search(initials);
        return lecture;
    }

    public void add(Lecture obj) {
        Subject subject = obj.getSubject();
        Lecture lecture = search(subject.getInitials());
        if (lecture == null) {
            this.lectures.add(obj);
        } else {
            String msg = "Lecture: " + subject.getInitials() + " already exists";
            throw new DuplicatedDataException(msg);
        }
    }

    public void remove(String initials) {
        Lecture lecture = search(initials);
        if (lecture != null) {
            this.lectures.remove(lecture);
        }
    }


}
